﻿#include  "StdAfx.h"

#include  "szArchiveFileExtractorImpl.hpp"
#include  <szArchiveOpenClientCallback.hpp>
#include  <szArchiveFileExtractClientCallback.hpp>
#include  <szGetPasswordClientCallback.hpp>
#include  <szTime.hpp>

SZ_NS_BEG(szpp)

ArchiveFileExtractorImpl::ArchiveFileExtractorImpl(
  ArchiveOpenClientCallback *openCallback,
  ArchiveFileExtractClientCallback *extCallback,
  GetPasswordClientCallback *pwdCallback)
:
#ifndef _NO_CRYPTO
  openPwdDefined(false), openPwdAsked(false), openPwd(), extPwdDefined(false), extPwd(),
#endif
  openCallback(openCallback), extCallback(extCallback), pwdCallback(pwdCallback)
{
}

ArchiveFileExtractorImpl::~ArchiveFileExtractorImpl()
{
}

//
// IOpenCallbackUI
//

#ifndef _NO_CRYPTO
HRESULT ArchiveFileExtractorImpl::Open_CryptoGetTextPassword(BSTR *password)
{
  openPwdAsked = true;

  // コールバックが設定すらされていない場合は S_FALSE を返すようにしている
  HRESULT hr = S_FALSE;
  if (0 != pwdCallback)
  {
    szstring clientPassword;
    if (SUCCEEDED(hr = pwdCallback->GetPassword(&clientPassword)))
    {
      openPwd.assign(clientPassword);
      openPwdDefined = true;
      hr = StringToBstr(clientPassword.c_str(), password);
    }
  }
  return hr;
}

HRESULT ArchiveFileExtractorImpl::Open_GetPasswordIfAny(UString &password)
{
  if (openPwdDefined)
    password = openPwd.c_str();
  return S_OK;
}

bool ArchiveFileExtractorImpl::Open_WasPasswordAsked()
{
  return openPwdAsked;
}

void ArchiveFileExtractorImpl::Open_ClearPasswordWasAskedFlag()
{
  openPwdAsked = false;
}
#endif

HRESULT ArchiveFileExtractorImpl::Open_CheckBreak()
{
  return S_OK;
}

HRESULT ArchiveFileExtractorImpl::Open_SetTotal(const UInt64 *files, const UInt64 *bytes)
{
  if (0 != openCallback)
  {
    const u64 nFiles = (files ? *files : 0);
    const u64 nBytes = (bytes ? *bytes : 0);
    return openCallback->SetTotal(nFiles, nBytes);
  }

  return S_OK;
}

HRESULT ArchiveFileExtractorImpl::Open_SetCompleted(const UInt64 *files, const UInt64 *bytes)
{
  if (0 != openCallback)
  {
    const u64 nFiles = (files ? *files : 0);
    const u64 nBytes = (bytes ? *bytes : 0);
    return openCallback->SetCompleted(nFiles, nBytes);
  }

  return S_OK;
}

//
// IProgress
//

STDMETHODIMP ArchiveFileExtractorImpl::SetTotal(UInt64 total)
{
  if (0 != extCallback)
    return extCallback->SetTotal(static_cast<u64>(total));
  return S_OK;
}

STDMETHODIMP ArchiveFileExtractorImpl::SetCompleted(const UInt64 *completeValue)
{
  if (0 != extCallback)
    return extCallback->SetCompleted(static_cast<u64>(*completeValue));
  return S_OK;
}

#ifndef _NO_CRYPTO
//
// IPassword
//
STDMETHODIMP ArchiveFileExtractorImpl::CryptoGetTextPassword(BSTR *password)
{
  if (!extPwdDefined)
  {
    if (0 == extCallback)
      return S_FALSE;

    HRESULT hr = extCallback->CryptoGetTextPassword(&extPwd);
    if (FAILED(hr))
      return hr;
  }

  // コールバックが設定すらされていない場合は S_FALSE を返すようにしている
  return StringToBstr(extPwd.c_str(), password);;
}
#endif

//
// IExtractCallbackUI (IFolderArchiveExtractCallback portion)
//

STDMETHODIMP ArchiveFileExtractorImpl::AskOverwrite(
  const wchar_t *existName, const FILETIME *existTime, const UInt64 *existSize,
  const wchar_t *newName, const FILETIME *newTime, const UInt64 *newSize,
  Int32 *answer)
{
  if (0 != extCallback)
  {
    const szstring estr(existName), nstr(newName);
    const Time etime(*reinterpret_cast<const s64 *>(existTime)), ntime(*reinterpret_cast<const s64 *>(newTime));
    const u64 esize(*existSize), nsize(*newSize);
    return extCallback->AskOverwrite(estr, etime, esize, nstr, ntime, nsize, reinterpret_cast<u32 *>(answer));
  }
  // コールバックが設定されていないときは「すべてはい」を選択したことにする（そうしないと話が先に進まないので）
  *answer = NOverwriteAnswer::kYesToAll;
  return S_OK;
}

STDMETHODIMP ArchiveFileExtractorImpl::PrepareOperation(const wchar_t *name, bool isFolder, Int32 askExtractMode, const UInt64 *position)
{
  if (0 != extCallback)
  {
    const szstring namestr(name);
    return extCallback->PrepareOperation(namestr, isFolder, static_cast<u32>(askExtractMode), *static_cast<const u64 *>(position));
  }
  return S_OK;
}

STDMETHODIMP ArchiveFileExtractorImpl::MessageError(const wchar_t *message)
{
  if (0 != extCallback)
  {
    const szstring messagestr(message);
    return extCallback->MessageError(messagestr);
  }
  return S_OK;
}

STDMETHODIMP ArchiveFileExtractorImpl::SetOperationResult(Int32 operationResult, bool encrypted)
{
  if (0 != extCallback)
    return extCallback->SetOperationResult(static_cast<u32>(operationResult), encrypted);
  return S_OK;
}

//
// IExtractCallbackUI
//

HRESULT ArchiveFileExtractorImpl::BeforeOpen(const wchar_t *name)
{
  if (0 != extCallback)
  {
    const szstring namestr(name);
    return extCallback->BeforeOpen(namestr);
  }
  return S_OK;
}

HRESULT ArchiveFileExtractorImpl::OpenResult(const wchar_t *name, HRESULT result, bool encrypted)
{
  if (0 != extCallback)
  {
    const szstring namestr(name);
    return extCallback->OpenResult(namestr, result, encrypted);
  }
  return S_OK;
}

HRESULT ArchiveFileExtractorImpl::ThereAreNoFiles()
{
  if (0 != extCallback)
    return extCallback->ThereAreNoFiles();
  return S_OK;
}

HRESULT ArchiveFileExtractorImpl::ExtractResult(HRESULT result)
{
  if (0 != extCallback)
    return extCallback->ExtractResult(result);
  return S_OK;
}

#ifndef _NO_CRYPTO
HRESULT ArchiveFileExtractorImpl::SetPassword(const UString &password)
{
  extPwdDefined = true;
  extPwd = password;
  if (0 != extCallback)
    return extCallback->SetPassword(extPwd);
  return S_OK;
}
#endif

#ifndef _NO_CRYPTO
void ArchiveFileExtractorImpl::SetInitialPassword(const szstring &password)
{
  extPwdDefined = true;
  extPwd.assign(password);
  openPwdDefined = true;
  openPwd.assign(password);
}
#endif

SZ_NS_END(szpp)
